IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'EST_MOVIMENTO_COMPRAS') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_MOVIMENTO_COMPRAS](
	[CD_CTR_COMPRAS] [int] IDENTITY(1,1) NOT NULL,
	[CD_CTR_DT_MOVIMENTO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_MOV_OP] [int] NOT NULL,
	[DS_MOV_OP] [varchar](100) NOT NULL,
	[VLR_COMPRAS] [money] NOT NULL,
	[VLR_DESC] [money] NOT NULL,
	[VLR_ICMS_SUBS] [money] NOT NULL,
	[VLR_FRETE] [money] NOT NULL,
	[VLR_IPI] [money] NOT NULL,
	[VLR_COMPRAS_LIQ] [money] NOT NULL,
	[DS_TIPO_TRANSACAO] [varchar](350) NOT NULL,
	[TIPO_TRANSACAO] [int] NOT NULL,
	[VLR_OUTRAS_DESPESAS] [money] NOT NULL,
	[VLR_ICMS_DESONERADO] [money] NOT NULL,
 CONSTRAINT [PK_EST_MOVIMENTO_COMPRAS] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_COMPRAS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_CD_CTR_DT_MOVIMENTO]  DEFAULT ((0)) FOR [CD_CTR_DT_MOVIMENTO]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_CD_MOV_OP]  DEFAULT ((0)) FOR [CD_MOV_OP]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_DS_MOV_OP]  DEFAULT ('') FOR [DS_MOV_OP]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_VLR_COMPRAS]  DEFAULT ((0)) FOR [VLR_COMPRAS]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_VLR_DESC]  DEFAULT ((0)) FOR [VLR_DESC]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_VLR_ICMS_SUBS]  DEFAULT ((0)) FOR [VLR_ICMS_SUBS]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_VLR_FRETE]  DEFAULT ((0)) FOR [VLR_FRETE]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_VLR_IPI]  DEFAULT ((0)) FOR [VLR_IPI]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_VLR_COMPRAS_LIQ]  DEFAULT ((0)) FOR [VLR_COMPRAS_LIQ]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_TIPO_TRANSACAO]  DEFAULT ('') FOR [DS_TIPO_TRANSACAO]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_TIPO_TRANSACAO_1]  DEFAULT ((0)) FOR [TIPO_TRANSACAO]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_VLR_OUTRAS_DESPESAS]  DEFAULT ((0)) FOR [VLR_OUTRAS_DESPESAS]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_COMPRAS_VLR_ICMS_DESONERADO]  DEFAULT ((0)) FOR [VLR_ICMS_DESONERADO]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOVIMENTO_COMPRAS_GLB_DT_MOVIMENTO] FOREIGN KEY([CD_CTR_DT_MOVIMENTO])
REFERENCES [dbo].[GLB_DT_MOVIMENTO] ([CD_CTR_DT_MOVIMENTO])

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] CHECK CONSTRAINT [FK_EST_MOVIMENTO_COMPRAS_GLB_DT_MOVIMENTO]

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOVIMENTO_COMPRAS_GLB_MOV_OP] FOREIGN KEY([CD_MOV_OP])
REFERENCES [dbo].[GLB_MOV_OP] ([CD_MOV_OP])

ALTER TABLE [dbo].[EST_MOVIMENTO_COMPRAS] CHECK CONSTRAINT [FK_EST_MOVIMENTO_COMPRAS_GLB_MOV_OP]
end